// This is the main entry point for this Incisor® project. 
// Throughout the project, this object can be referenced as 'pr'.
class ProjectMain
{
    init()
    {
        /*
        this.safearea = new GraphicObject(nc.graphicAssets.WhiteBox, nc.mainScene, "safearea");
        this.safearea.scale.x = 2160 * .01;
        this.safearea.scale.y = 2160 * .01;
        this.safearea.colorMultiply.red = 0;
        this.safearea.colorMultiply.alpha = 0.1;
        */

        //This fixes the camera
        nc.mainCamera.adaptiveCameraMode = constants.adaptiveCameraModes.maximizeSafeZone;
        // This adds kitchen construct to live view, aka mainScene
        this.kitchen = nc.constructDefs.Kitchen.add(nc.mainScene);
        //This plays moving receipt animation
        this.kitchen.timelines.IdleKitchen.play();
        this.kitchen.timelines.IdleKitchen.influence = 1;

        this.message = nc.constructDefs.Message.add(this.kitchen);
        this.message.scale.x = .35;
        this.message.scale.y = .35;
        this.message.position.x = -700;
        this.message.position.y = -1500;
        this.message.timelines.Toss.influence = 1;

        // This retrieves the chef construct
        this.chef = this.kitchen.descendantsByName.Chef;
        // This retrieves the chef construct animations
        this.chef.timelines.Idle.play();
        this.chef.timelines.Walk.play();
        this.chef.timelines.Run.play();

        // This makes the chef character smaller in the live view
        this.chef.scale.x = .5;
        this.chef.scale.y = .5;
        // This makes the chef's starting position at the center of the screen
        this.chef.position.x = 250;
        // The chef's speed is defined at zero
        this.chef.speed = 0;

        // Adds the impact animation to kitchen construct
        this.impact = nc.constructDefs.Impact.add(this.kitchen);
        this.impact.scale.scaleByFactor(.25);
        // Disables the animation, so it doesn't play automatically
        this.impact.disable();

        // Creates 3 new variables concerning the falling objects
        this.fallingObjects = [];
        this.fallingObjectIndex = 0;
        this.numberOfItemsCaught = 0;
        this.currentOrderLine = 0;

        // Creates falling objects in the kitchen
        for (let i = 0; i < 12; i++) 
        {
            let obj = new FallingObject(nc.graphicAssets.WhiteBox, this.kitchen, "fallingObject");
            this.fallingObjects.push(obj);
        }

        // Array of Falling objects
        this.fallingObjectNames = ["Bottle Poison", "Bottle Sauce", "Cube Cheese", "Cube Lego", "Cylinder Land mine", "Cylinder Pepperoni", "Pointy Knife", "Pointy Pepper", "Semicircle Pepper", "Semicircle Teeth", "Torus Pineapple", "Torus Saw"];

        this.badObjects = ["Bottle Poison", "Cube Lego", "Cylinder Land mine", "Pointy Knife", "Semicircle Teeth", "Torus Saw"];

        this.currentListOfIngredients = [];

        this.level = 1;

        this.difficulty = 1;

        this.score = 100 * this.level;

        for (let i = 0; i < 7; i++)
        {
            // This changes the numbers on the receipt to be 1-7
            this.kitchen.descendantsByName["OrderLine" + i].descendantsByName.ListNumber.string = (i + 1).toString();

            // // Enables Ingredients on receipt
            this.kitchen.descendantsByName["OrderLine" + i].descendantsByName.Ingredient.enable();

            let index = Math.floor(Math.random() * this.badObjects.length);

            this.kitchen.descendantsByName["OrderLine" + i].descendantsByName.Ingredient.graphicAsset = nc.graphicAssets[this.badObjects[index]];

            this.currentListOfIngredients.push(this.badObjects[index]);

            // Sets up ascending possible scores on receipt
            this.kitchen.descendantsByName["OrderLine" + (i)].descendantsByName.PossibleScore.string = this.score.toString();
            this.score += 100;
        }

        // Highlight box
        this.box = this.kitchen.descendantsByName["ListBox"];

        // Set Score to zero
        this.scoreTally = 0;
        this.scores = [100, 200, 300, 400, 500, 600, 700];

        this.failScreen = nc.constructDefs.LevelFail.add(nc.mainScene);
        this.failScreen.disable();

        this.failScreen.descendantsByName.Restart.addReleaseCallback(this, "start");

        this.successScreen = nc.constructDefs.LevelSuccess.add(nc.mainScene);
        this.successScreen.disable();

        this.successScreen.descendantsByName.NextOrder.addReleaseCallback(this, "start");

        // This is the start screen, it pauses the main scene, and pulses until it is clicked
        this.titleScreen = nc.constructDefs.TitleScreen.add(nc.mainScene);
        this.startButton = this.titleScreen.descendantsByName.PlayButton;

        this.startButton.addReleaseCallback(this, "start");

        //This animates the title screen
        this.titleScreen.scale.addMotion.all(.9, 1.1, .3, nc.motionTypes.TitleSway);
        this.startButton.scale.addMotion.all(1, 1.3, .3, nc.motionTypes.TitleSway);

        // Disable the kitchen so it doesn't show on the start screen
        this.kitchen.disable();

        // Kick off the title music
        nc.sounds.TitleMusic.mainVolume = .5;
        nc.sounds.TitleMusic.play();

        this.kitchen.descendantsByName.LeftArrow.addPressCallback(this, "setArrowPressed", ["Left"]);
        this.kitchen.descendantsByName.RightArrow.addPressCallback(this, "setArrowPressed", ["Right"]);

        this.kitchen.descendantsByName.LeftArrow.addReleaseCallback(this, "setArrowReleased", ["Left"]);
        this.kitchen.descendantsByName.RightArrow.addReleaseCallback(this, "setArrowReleased", ["Right"]);

        this.kitchen.descendantsByName.LeftArrow.addCursorOutCallback(this, "setArrowReleased", ["Left"]);
        this.kitchen.descendantsByName.RightArrow.addCursorOutCallback(this, "setArrowReleased", ["Right"]);

        this.leftArrowPressed = false;
        this.leftArrowReleased = true;

        this.rightArrowPressed = false;
        this.rightArrowReleased = true;


    }

    start()
    {
        // Switch to base game music
        nc.sounds.HappyBell.playOnce();
        nc.sounds.TitleMusic.stop();
        nc.sounds.BaseGameMusic.mainVolume = .5;
        nc.sounds.BaseGameMusic.play();

        //enable kitchen and disable the start screen
        this.kitchen.enable();
        this.titleScreen.disable();
        this.failScreen.disable();
        this.successScreen.disable();

        // This creates a pause of 3 seconds before dropping objects
        nc.waitThen(3, this, "dropObject");

        // Defines app events, one to be triggered when a key is pressed, and a fixed update callback
        let myAppEvent1 = nc.appEvents.fixedUpdate;
        myAppEvent1.addCallback(this, "fixedUpdateCallback");
    }

    //the DropObject function uses a random number to call for objects from the falling object index, 
    //then calls StartFalling function, waits 1 sec then repeats
    dropObject()
    {
        if (this.fallingObjectIndex === 11)
        {
            this.fallingObjectIndex = 0;
        }
        else
        {
            this.fallingObjectIndex += 1;
        }

        let index = Math.floor(Math.random() * this.fallingObjectNames.length);

        this.fallingObjects[this.fallingObjectIndex].setFallingObject(this.fallingObjectNames[index]);
        nc.waitThen(1, this, "dropObject");
    }

    roundComplete(successful)
    {
        nc.appEvents.fixedUpdate.removeCallback(this, "fixedUpdateCallback");
        nc.stopAllWaitThensByCallback(this, "dropObject");

        this.fallingObjectIndex = 0;
        this.numberOfItemsCaught = 0;
        this.currentOrderLine = 0;

        this.box.position.y = -495;

        for (let i = 0; i < 30; i++)
        {
            this.chef.descendantsByName["Item" + i].disable();
        }

        for (let i = 0; i < 7; i++)
        {
            this.kitchen.descendantsByName["OrderLine" + i].descendantsByName.Check.disable();
        }

        for (let i = 0; i < 12; i++)
        {
            this.fallingObjects[i].disable();
        }

        this.chef.timelines.Idle.influence = 1;

        if (successful === true)
        {
            this.level++;
            this.kitchen.descendantsByName.LevelNumber.orderLevel.string = this.level.toString();
            this.difficulty -= .1;

            this.successScreen.enable();
            this.successScreen.scale.addMotion.all(.95, 1.05, .3, nc.motionTypes.TitleSway);
            this.successScreen.descendantsByName.NextOrder.scale.addMotion.all(1, 1.05, .3, nc.motionTypes.TitleSway);

            this.currentListOfIngredients = [];

            for (let i = 0; i < 7; i++)
            {
                // Enables Ingredients on receipt
                this.kitchen.descendantsByName["OrderLine" + (i)].descendantsByName.Ingredient.graphicAsset = nc.graphicAssets[this.badObjects[index]];

                index = Math.floor(Math.random() * this.badObjects.length);

                this.currentListOfIngredients.push(this.badObjects[index]);
            }
        }

        if (successful === false)
        {
            this.failScreen.enable();
            this.failScreen.scale.addMotion.all(.95, 1.05, .3, nc.motionTypes.TitleSway);
            this.failScreen.descendantsByName.Restart.scale.addMotion.all(1, 1.1, .3, nc.motionTypes.TitleSway);
        }
    }

    setArrowPressed(event, scene, whichArrow)
    {
        if (nc.keyDownStates.ArrowLeft !== true && nc.keyDownStates.ArrowRight !== true)
        {
            if (whichArrow === "Left" && this.rightArrowReleased === true)
            {
                console.log("Pressed");
                this.leftArrowPressed = true;
                this.leftArrowReleased = false;

                this.kitchen.descendantsByName.LeftArrow.scale.swoop.all(.9, .1);
            }

            if (whichArrow === "Right" && this.leftArrowReleased === true)
            {
                this.rightArrowPressed = true;
                this.rightArrowReleased = false;

                this.kitchen.descendantsByName.RightArrow.scale.swoop.each([-.9, .9, 1], .1);
            }
        }
    }

    setArrowReleased(event, scene, whichArrow)
    {
        if (whichArrow === "Left")
        {
            this.leftArrowPressed = false;
            this.leftArrowReleased = true;

            this.kitchen.descendantsByName.LeftArrow.scale.swoop.all(1, .1);
        }

        if (whichArrow === "Right")
        {
            this.rightArrowPressed = false;
            this.rightArrowReleased = true;

            this.kitchen.descendantsByName.RightArrow.scale.swoop.each([-1, 1, 1], .1);
        }
    }

    // The fixedUpdateCallback constantly refreshes during the live view, 
    // Function determines if the left/right arrow keys are pressed down
    // And if they're down determines the direction, speed, and influence of animations of Chef
    fixedUpdateCallback(params) 
    {
        //creates trigger area on plate that moves vertically as plate gets taller;

        // let handPos = this.chef.descendantsByName["Item" + this.numberOfItemsCaught].getGlobalPosition();
        let handPos = this.chef.descendantsByName["Item" + this.numberOfItemsCaught].getGlobalPosition();

        // //For all 12 objects, while objects fall in a certain range. The objects will stop, and be replaced  
        for (let i = 0; i < this.fallingObjects.length; i++) 
        {
            if (this.fallingObjects[i].enabled === true)
            {
                // Gets the position of the falling objects, and if they come close enough to the hand position the object will stop
                let fallingObjPos = this.fallingObjects[i].getGlobalPosition();

                if (fallingObjPos.x > handPos.x - 100 && fallingObjPos.x < handPos.x + 100 && fallingObjPos.y > handPos.y - 100 && fallingObjPos.y < handPos.y + 100
                )
                {
                    this.fallingObjects[i].disable();
                    this.impact.enable();
                    this.impact.position.x = handPos.x;
                    this.impact.position.y = handPos.y;
                    this.impact.timelines.Splat.influence = 1;
                    this.impact.timelines.Splat.playOnce();


                    this.chef.descendantsByName["Item" + this.numberOfItemsCaught].enable();

                    //Adds correct falling object side graphic to plate
                    let sideName = this.fallingObjects[i].objectName + "_Side";

                    this.chef.descendantsByName["Item" + this.numberOfItemsCaught].graphicAsset = nc.graphicAssets[sideName];

                    this.numberOfItemsCaught++;

                    if (this.fallingObjects[i].objectName == this.currentListOfIngredients[this.currentOrderLine])
                    {

                        this.kitchen.descendantsByName["OrderLine" + (this.currentOrderLine)].descendantsByName.Check.enable();

                        this.message.enable();
                        this.message.descendantsByName.Wrong.disable();
                        this.message.descendantsByName.GoodJob.enable();
                        this.message.timelines.Toss.playOnce(this.message, "disable");

                        nc.sounds.HappyBell.mainVolume = .5;
                        nc.sounds.HappyBell.playOnce();

                        this.scoreTally += this.scores[this.currentOrderLine];
                        this.kitchen.descendantsByName.ScoreNumber.string = this.scoreTally.toString();

                        this.currentOrderLine++;

                        this.box.position.y -= 175;
                    }
                    else if (this.fallingObjects[i].objectName != this.currentListOfIngredients[this.currentOrderLine])
                    {
                        this.kitchen.descendantsByName["OrderLine" + (this.currentOrderLine)].timelines.XFlash.influence = 1;
                        this.kitchen.descendantsByName["OrderLine" + (this.currentOrderLine)].timelines.XFlash.playOnce();

                        this.message.enable();
                        this.message.descendantsByName.GoodJob.disable();
                        this.message.descendantsByName.Wrong.enable();
                        this.message.timelines.Toss.playOnce(this.message, "disable");

                        nc.sounds.Buzzer.mainVolume = .5;
                        nc.sounds.Buzzer.playOnce();

                        this.scoreTally -= this.scores[this.currentOrderLine] * .5;
                        this.kitchen.descendantsByName.ScoreNumber.string = this.scoreTally.toString();
                    }

                    //if number of items caught = 20 then end the game / disable checkmarks and disable all chef caught items
                    if (this.numberOfItemsCaught === 20)
                    {
                        this.roundComplete(false);
                    }

                    // if currentOrderLine = 7 then win / next level / increase difficulty / reset order list and when level is completed, increase level number
                    if (this.currentOrderLine === 7)
                    {
                        this.roundComplete(true);
                    }




                }


            }

        }


        if (nc.keyDownStates.ArrowLeft === true || this.leftArrowPressed === true)
        {

            //Limit the chef's boundaries
            if (this.chef.position.x > -1000 && this.chef.position.x < 1000)
            {
                this.chef.position.x -= 20 * this.chef.speed;
            }
            if (this.chef.position.x < -1000)
            {
                this.chef.position.x = -999.99;
            }
            if (this.chef.position.x > 1000)
            {
                this.chef.position.x = 999.99;
            }

            //Limit the chef speed
            if (this.chef.speed < .8)
            {
                this.chef.speed += .01;
            }
            else
            {
                this.chef.speed = 1;
            }


            this.chef.scale.x = .5;

            //Limit the timeline influence to 1
            if (this.chef.timelines.Run.influence >= 1)
            {
                this.chef.timelines.Run.influence = 1;
            }
            else
            {
                this.chef.timelines.Run.influence += .01;
            }

            nc.sounds.FootstepsFast.play();
            nc.sounds.FootstepsFast.swoopVolume(.5, .1);
        }
        else if (nc.keyDownStates.ArrowRight === true || this.rightArrowPressed === true)
        {

            //Limit the chef's boundaries
            if (this.chef.position.x > -1000 && this.chef.position.x < 1000)
            {
                this.chef.position.x += 20 * this.chef.speed;
            }
            if (this.chef.position.x < -999.99)
            {
                this.chef.position.x = -1000;
            }
            if (this.chef.position.x > 1000)
            {
                this.chef.position.x = 999.99;
            }

            //Limit the chef speed
            if (this.chef.speed < .8)
            {
                this.chef.speed += .01;
            }
            else
            {
                this.chef.speed = 1;
            }

            this.chef.scale.x = -.5;

            //Limit the timeline influence to 1
            if (this.chef.timelines.Run.influence >= 1)
            {
                this.chef.timelines.Run.influence = 1;
            }
            else
            {
                this.chef.timelines.Run.influence += .01;
            }

            nc.sounds.FootstepsFast.play();
            nc.sounds.FootstepsFast.swoopVolume(.5, .1);
        }
        else
        {

            this.chef.speed = 0;
            if (this.chef.timelines.Idle.influence >= 1)
            {
                this.chef.timelines.Idle.influence = 1;
            }
            else
            {
                this.chef.timelines.Idle.influence += .05;
            }

            nc.sounds.FootstepsFast.swoopVolume(0, .1);
        }



    }


}